package gov.va.caret.portlet;


import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.CaretViewController;
import gov.va.caret.portlet.action.CaretActionCommand;
import gov.va.caret.portlet.resource.CaretResourceCommand;
import gov.va.caret.security.CAction;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.ZipFyLocalServiceUtil;
import gov.va.caret.service.ctssh.CTSSHFacade;
import gov.va.caret.service.ctssh.template.TemplateHandler;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.BootStrapUtil;

import java.io.IOException;

import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;


public class CaretPortlet extends CaretBasePortlet {
	
	public void init() throws PortletException {
		
		super.init();
		
		this.actionCommand = new CaretActionCommand();
		this.resourceCommand = new CaretResourceCommand();
		this.viewController = CaretViewController.getViewController();

		_log.info( "Initializing " + viewController.getVersion() );
		_log.info( "on " + ReleaseInfo.getReleaseInfo() );
			
		try{
			boolean isMviEnabled = Toolbox.isMviEnabled();
			String templates = PropsUtil.get( CTSSHFacade.FILE_TEMPLATE_STORE );
			
			
			
			_log.info("templates.environment=" + PropsUtil.get( "templates.environment" ) );
			_log.warn("portlet-ext.properties... search.mvi.attended.enabled=" + isMviEnabled);
			_log.warn("portlet-ext.properties..." + CTSSHFacade.FILE_TEMPLATE_STORE + "=" + templates);
			if ( isMviEnabled ){
				String TEMPLATE_ENV = PropsUtil.get( "templates.environment" );
				String TEMPLATE_LOCATION = PropsUtil.get( CTSSHFacade.FILE_TEMPLATE_STORE );
				TemplateHandler.init( TEMPLATE_LOCATION, TEMPLATE_ENV );
				
//				String[] realPath = new String[] { templates };
//				String[] realPath = new String[] {getPortletContext().getRealPath("templates") };

//				if ( realPath[0] != null ) {
//					CTSSHFacade.init( realPath );
//				} else {
//					boolean ctsshInitd = false;
//					try {
//						_log.warn("path was null trying getResource()");
//						realPath[0] = getPortletContext().getResource( "templates" ).toURI().toString();
//						CTSSHFacade.init( realPath );
//						ctsshInitd = true;
//					} catch (MalformedURLException e) {
//						_log.warn( "Malformed url error:" + e.getMessage() );
//					} catch (URISyntaxException e) {
//						_log.warn( "URI Syntax error:" + e.getMessage() );
//					}
//					if ( !ctsshInitd ){
//						_log.warn( "CTSSHFacade:using null default" );
//						realPath[0] = null;
//						CTSSHFacade.init( realPath );
//					}
//				}
			} 
			}catch ( Exception e ){
				e.printStackTrace();
			}
			try{	
				String[] realPath = new String[]{PropsUtil.get("spreadsheet.location")};
				_log.warn("portlet-ext.properties... spreadsheet.location=" + realPath[0]);
				_log.warn("portlet-ext.properties... init.bootstrap.enabled=" + PropsUtil.get("init.bootstrap.enabled") );
				if ( StringPool.TRUE.equals(PropsUtil.get("init.bootstrap.enabled") ) ){
					try {
						if ( OrganizationLocalServiceUtil.getOrganizationsCount() < 20 ){
							_log.info("begin bootstrap orgs...");
							BootStrapUtil.bootstrapOrgs( getPortletContext(), realPath );
						}
						_log.info("begin bootstrap persn...");
						BootStrapUtil.bootstrapPersonTable();
						
						if ( ZipFyLocalServiceUtil.getZipFiesCount() < 5 ){
							_log.info("begin bootstrap facility zip...");
							BootStrapUtil.bootstrapFacZip( getPortletContext(), realPath );
						}
						
						int	count = BlsReLocalServiceUtil.getBlsResCount();
						_log.info("bls zip count=" + count );
						if ( count < 50 ){
							_log.info("begin bootstrap bls Rates...");
							BootStrapUtil.loadBlsRate( getPortletContext(), realPath );
						}
						_log.info("init completed...");
					} catch (ApplicationWorkFlowException e1) {
						ApplicationWorkFlowException.handleException(e1);
					} catch (SystemException e) {
						ApplicationWorkFlowException.handleException(e);
					} catch (PortalException e) {
						ApplicationWorkFlowException.handleException(e);
					}
				}
		} catch ( Exception e ){
			_log.error( "INIT BOOTSTRAP FAILED..." );
			e.printStackTrace();
		}
		
		
	}
	
	protected void include( String path, RenderRequest renderRequest, RenderResponse renderResponse)
			throws IOException, PortletException {
		if ( CAction.canDoCaret( renderRequest, CAction.VIEW ) ){
//			CaretParam.loadPermission(renderRequest);
			super.include(path,renderRequest, renderResponse);
		}else {
			_log.info("VIEW needed");
		}
	}
	
	private static Log _log = LogFactoryUtil.getLog(CaretPortlet.class);

}